
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{AVEC_EA}[2025/08/19 AVEC'26 Extended Abstract Template]


\LoadClass[twocolumn]{article}

%packages
\RequirePackage{amsmath}
\RequirePackage{geometry}
\RequirePackage{multicol}
\RequirePackage{fancyhdr}
%\RequirePackage{times}
\RequirePackage{newtxtext,newtxmath}
\RequirePackage{graphicx}
\RequirePackage{enumitem}
\RequirePackage{indentfirst}
\RequirePackage{xcolor}
\RequirePackage{hyperref}
\makeatletter
%section format
  \renewcommand\section{%
    \@startsection{section}{1}
    {\z@}%
%   {-3.25ex\@plus -1ex \@minus -.2ex}%
%   {1sp}% No space after subsections
    {3.5mm}%
    {3.5mm}%
    {\centering\normalfont\fontsize{10}{10}\bfseries}}
  \renewcommand\subsection{%
    \@startsection{subsection}{2}
    {\z@}%
%   {-3.25ex\@plus -1ex \@minus -.2ex}%
%   {1sp}% No space after subsections
    {3.5mm}%
    {1sp}%
    {\normalfont\normalsize}}
  \renewcommand\subsubsection{%
    \@startsection{subsubsection}{3}
    {\z@}%
%   {-3.25ex\@plus -1ex \@minus -.2ex}%
%   {1sp}% No space after subsubsections
    {3.5mm}%
    {1sp}%
    {\normalfont\normalsize}}
  \renewcommand\@seccntformat[1]{%
    \@ifundefined{#1@cntformat}%
    {\csname the#1\endcsname\quad}%
    {\csname #1@cntformat\endcsname}}
  \newcommand\section@cntformat{\thesection. }
  \newcommand\subsection@cntformat{\thesubsection. }
  \newcommand\subsubsection@cntformat{\thesubsubsection. }
%bibliography format
  \renewcommand{\@cite}[1]{(#1)}
  \renewcommand{\@biblabel}[1]{(#1)}
  \renewenvironment{thebibliography}[1]
{\section*{\refname}\@mkboth{\refname}{\refname}%
  \list{\@biblabel{\@arabic\c@enumiv}}%
       {\settowidth\labelwidth{\@biblabel{#1}}%
        \leftmargin\labelwidth
        \advance\leftmargin\labelsep
 \setlength\itemsep{-3.0pt}%between lines
 \setlength\baselineskip{11.4pt}%between items
        \@openbib@code
        \usecounter{enumiv}%
        \let\p@enumiv\@empty
        \renewcommand\theenumiv{\@arabic\c@enumiv}}%
  \sloppy
  \clubpenalty4000
  \@clubpenalty\clubpenalty
  \widowpenalty4000%
  \sfcode`\.\@m}
 {\def\@noitemerr
   {\@latex@warning{Empty `thebibliography' environment}}%
  \endlist}
\makeatother



\geometry{a4paper, top=30mm, bottom=25mm, left=20mm, right=20mm, headheight=4.6mm, headsep=12.7mm, footskip=12.7mm}
\setlength{\columnsep}{9.9mm}
\setlength{\parindent}{6.2mm}
\setlength{\parskip}{0em}
%\setlength{\topskip}{0mm}
%\renewcommand{\baselinestretch}{0}

\pagestyle{fancy}
\fancyhead{}
\fancyhead[L]{\normalsize\textcolor{black}{AVEC'26}}
\fancyfoot[C]{\thepage}
\fancyfoot{}
\renewcommand{\headrulewidth}{0pt} %no header line


\newcommand{\titlesize}{\fontsize{18}{18}\selectfont}
\newcommand{\authorsize}{\fontsize{12}{12}\selectfont}
\newcommand{\affiliationsize}{\fontsize{12}{12}\selectfont}
\newcommand{\contactsize}{\fontsize{10}{10}\selectfont}
\newcommand{\keywordsympsize}{\fontsize{10}{10}\selectfont}
\newcommand{\normalsizefont}{\fontsize{10}{10}\selectfont}

\renewcommand{\baselinestretch}{0.96}

\newcommand{\papertitle}[1]{
\renewcommand{\baselinestretch}{1.2}
\vspace{-5mm}
\begin{center}\titlesize\bfseries #1\vspace{3.5mm}\end{center}
}
\newcommand{\authors}[1]{\begin{center}\authorsize\bfseries #1\vspace{-4.0mm}\end{center}}
\newcommand{\affiliations}[1]{\begin{center}\affiliationsize\bfseries #1\vspace{1.5mm}\end{center}}
\newcommand{\contactinfo}[1]{\begin{center}\contactsize #1\vspace{7.0mm}\end{center}}
\newcommand{\keywords}[1]{\begin{center}\keywordsympsize{Keyword(s): #1}\end{center}\vspace{-7.6mm}}
\newcommand{\symposiumtopic}[1]{\begin{center}\keywordsympsize{Corresponding Symposium Topic(s): #1}\end{center}\vspace{2.2mm}
\renewcommand{\baselinestretch}{0.97}
}



\endinput
